package com.elitesland.inv.dto.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 详细数据查询参数
 * </p>
 *
 * @author diver27
 * @since 2020-9-10
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class InvStkDRpcDtoParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -5533623616140367494L;
    @ApiModelProperty("品牌")
    private List<String> brands;

    @ApiModelProperty("零库存显示")
    private Boolean noStk;

    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private List<Long> ouIds;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    private List<Long> buIds;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    private List<Long> itemIds;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    private List<Long> variIds;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private List<String> itemCodes;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private List<Long> whIds;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private List<String> deter2s;
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    private List<String> lotNos;
    /**
     * 序列号
     */
    @ApiModelProperty("序列号")
    private String snNo;
    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("库存合作伙伴编码（暂时使用）")
    String pCode;

    @ApiModelProperty("库存合作伙伴名称")
    String pName;

    @ApiModelProperty("库存合作伙伴类型（暂时使用）")
    String pType;

    @ApiModelProperty("仓库类型 （暂时使用）")
    List<String> whTypes;
    String whType;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE3（暂时使用）")
    String itemType;

}
