package com.elitesland.inv.dto.invstk;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订货小程序查询库存返回
 */
@Data
@ApiModel("订货小程序查询库存返回")
public class InvStkStoreMpRpcDTO implements Serializable {

    private static final long serialVersionUID = -6387906375365034965L;

    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("批次ID")
    private Long lotId;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名")
    private String itemName;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名")
    private String whName;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ExcelProperty(value = "库存数量")
    private BigDecimal ohQty;

    @ApiModelProperty("锁定数量")
    private BigDecimal lockQty;

}
