package com.elitesland.inv.dto.invwhAreaSetting;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Data
public class InvWhAreaSettingParamRpcDTO  implements Serializable {
    private static final long serialVersionUID = -374682536552039943L;

    @ApiModelProperty("功能区类型ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    @ApiModelProperty("功能区类型编码集合")
    private List<String> deter2Types;

    @ApiModelProperty("可使用仓库类型编码、可多选、逗号分隔存储")
    private List<String> whTypes;

    @ApiModelProperty("建仓前端是否可选 [UDC]INV:BUSINESS_CHOOSE")
    private Boolean businessChoose;

    @ApiModelProperty("是否零价库 [UDC]INV:ZERO_WH")
    private Boolean isZeroWh;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    private String status;


}
