package com.elitesland.inv.dto.thaliItem;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author Mark
 * @description:
 * @datetime 2024年 09月 10日 13:10
 * @version: 1.0
 */
@Data
@ApiModel(value = "ThaliItemQtyQueryParamVO ", description = "菜品可售数量查询参数对象")
public class ThaliItemQtyQueryRpcParamVO implements Serializable {

    /**
     * 门店编码列表
     */
    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码为空")
    private List<String> storeCodes;

    /**
     * 菜品编码列表
     */
    @ApiModelProperty(value = "菜品编码列表")
    private List<String> thaliItemCodes;

    /**
     * 规格值编码列表
     */
    @ApiModelProperty(value = "规格值编码列表")
    private List<String> sizeCodes;

}
