package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.boh.StoreOrderRpcDTO;
import com.elitesland.inv.dto.boh.StoreRtnApplyResult;
import com.elitesland.inv.dto.invTrn.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + StoreOrderTrnProvider.PATH)
public interface StoreOrderTrnProvider {
    String PATH = "/storeOrderTrn";

    /**
     * 订货集推送生成调拨单
     * @param storeOrderTrnRpcDTOs
     * @return
     */
    @PostMapping("/create")
    ApiResult<List<StoreOrderTrnResultDTO>> generateTrn(@RequestBody List<StoreOrderTrnRpcDTO> storeOrderTrnRpcDTOs);


    /**
     * 门店小程序收货
     *
     * @param storeReceiveRpcDTO
     * @return
     */
    @PostMapping("/receive")
    ApiResult receive(@RequestBody StoreReceiveRpcDTO storeReceiveRpcDTO);

    /**
     * 门店小程序退货
     *
     * @param storeRtnRpcDTO
     * @return
     */
    @PostMapping("/rtn")
    ApiResult rtn(@RequestBody StoreRtnRpcDTO storeRtnRpcDTO);

    /**
     * 门店小程序退货申请
     *
     * @param storeRtnRpcDTO
     * @return
     */
    @PostMapping("/rtnApply")
    ApiResult<StoreRtnApplyResult> rtnApply(@RequestBody StoreRtnRpcDTO storeRtnRpcDTO);

    /**
     * 查询退货单明细可退数量和库存可供量
     * @param id
     * @return
     */
    @GetMapping("/canRtn")
    ApiResult<List<StoreCanRtnQtyRpcDTO>> canRtn(@RequestParam("id") Long id, @RequestParam("docType") String docType);

    @GetMapping("/detail")
    ApiResult<StoreOrderRpcDTO> detail(@RequestParam("id") Long id, @RequestParam("docType") String docType, @RequestParam("rtType") String rtType);

    @PostMapping("/findApproving")
    ApiResult<List<Long>> findApproving(@RequestBody List<Long> ids);

    @PostMapping("/abort")
    ApiResult abort(@RequestParam("id") Long id);
}
