package com.elitesland.inv.dto.odo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 23日 13:39
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvOdoSaveRpcDTO", description = "库存出库单")
public class InvOdoSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -1288939798948998849L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("发货时间")
    private LocalDateTime shipmentDate;

    @ApiModelProperty("要求发货时间")
    private LocalDateTime demandDate;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员员工编号")
    private String agentEmpCode;

    @ApiModelProperty("业务员名")
    private String agentEmpName;

    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;

    @ApiModelProperty("承运信息")
    private String deliveryDesc;

    @ApiModelProperty("签收用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long confirmUserId;

    @ApiModelProperty("签收人")
    private String confirmUserName;

    @ApiModelProperty("收货地址号")
    private String recvAddrNo;

    @ApiModelProperty("收货地址联系人")
    private String recvContactName;

    @ApiModelProperty("收货地址电话")
    private String recvContactTel;

    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("来源单据类别")
    @NotBlank(message = "来源单据类别不能为空")
    private String relateDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "来源单据ID不能为空")
    private Long relateDocId;

    @ApiModelProperty("来源单据编号")
    @NotBlank(message = "来源单据编号不能为空")
    private String relateDocNo;

    @ApiModelProperty("来源单据关联单据类别")
    private String relateDoc2Cls;

    @ApiModelProperty("来源单据关联关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;

    @ApiModelProperty("来源单据关联关联单据编号")
    private String relateDoc2No;

    @ApiModelProperty("限定1")
    private String deter1;

    @ApiModelProperty("限定3")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("来源系统")
    private String es5;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审批人名")
    private String apprUserName;

    @ApiModelProperty("团内/团外")
    private Boolean scene;

    @ApiModelProperty("是否越库")
    private Boolean crossFlag;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long logisCarrierId;
    /**
     * 物流公司编号
     */
    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;
    /**
     * 物流费用
     */
    @ApiModelProperty("物流费用")
    private BigDecimal logisFee;
    /**
     * 物流配送人
     */
    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("单据明细")
    @NotEmpty(message = "单据明细不能为空")
    private List<InvOdoDSaveRpcDTO> odoDSaveRpcDTOS;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

}
