package com.elitesland.inv.dto.out;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询mws相关参数
 */
@Data
public class InvOutSysQueryDTO implements InvOutSysQueryParam {

    @ApiModelProperty("推送WMS状态")
    private List<String> wmsStatus;

    @ApiModelProperty("推送WMS时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsTimeBegin;

    @ApiModelProperty("推送WMS时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsTimeEnd;

    @ApiModelProperty("接收WMS回传状态")
    private List<String> wmsFeedbackStatus;

    @ApiModelProperty("撤回WMS时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsCancelTimeBegin;

    @ApiModelProperty("撤回WMS时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsCancelTimeEnd;

    public static InvOutSysQueryDTO build(InvOutSysQueryParam param) {
        InvOutSysQueryDTO dto = new InvOutSysQueryDTO();
        dto.setWmsCancelTimeBegin(param.getWmsCancelTimeBegin());
        dto.setWmsStatus(param.getWmsStatus());
        dto.setWmsCancelTimeEnd(param.getWmsCancelTimeEnd());
        dto.setWmsTimeEnd(param.getWmsTimeEnd());
        dto.setWmsTimeBegin(param.getWmsTimeBegin());
        dto.setWmsFeedbackStatus(param.getWmsFeedbackStatus());
        return dto;
    }
}
