package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invwh.InvWhAreaParamRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhAreaSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 库区
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021/7/17
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvWhAreaProvider.PATH)
public interface InvWhAreaProvider {
    String PATH = "/invWhArea";

    /**
     * 根据仓库ID 查询库区
     * @param whId
     * @return
     */
    @GetMapping("/findByWhId")
    List<InvWhAreaRpcDTO> findByWhId(@RequestParam("whId") Long whId);

    /**
     * 根据库区id查询库区
     * @param id
     * @return
     */
    @GetMapping("/findByAreaId")
    InvWhAreaRpcDTO findByAreaId(@RequestParam("id") Long id);

    /**
     * 根据仓库id 列表批量查询库区
     * @param whIds
     * @return
     */
    @PostMapping("/findByWhIds")
    List<InvWhAreaRpcDTO> findByWhIds(@RequestBody List<Long> whIds);

    /**
     * 创建库区
     * @param
     * @return
     */
    @PostMapping("/createBatch")
    List<Long> createBatch(@RequestBody List<InvWhAreaSaveDTO> list);

    /**
     * 根据whId删除库区
     * @param
     * @return
     */
    @PostMapping("/deleteByWhId")
    ApiResult deleteByWhId(@RequestParam("whId") Long whId);

    /**
     * 根据Id删除库区
     * @param
     * @return
     */
    @PostMapping("/deleteByid")
    ApiResult deleteByAreaId(@RequestBody List<Long> ids);


    /**
     * 仓库功能区查询
     * @param param
     * @return
     */
    @PostMapping("/getDeter2List")
    List<InvWhAreaRpcDTO> findDeter2List(@RequestBody InvWhAreaParamRpcDTO param);








}
