package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.thaliItem.ThaliItemCalPreSellQtyRpcParamVO;
import com.elitesland.inv.dto.thaliItem.ThaliItemCalPreSellQtyRpcRespVO;
import com.elitesland.inv.dto.thaliItem.ThaliItemQtyQueryRpcParamVO;
import com.elitesland.inv.dto.thaliItem.ThaliItemQtyQueryRpcRespVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/9/10 13:48
 * @Description:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ThaliItemQtyProvider.PATH)
public interface ThaliItemQtyProvider {

    String PATH = "/thaliItemQty";

    @PostMapping("/query")
    List<ThaliItemQtyQueryRpcRespVO> queryInvQuantityByCode(@RequestBody ThaliItemQtyQueryRpcParamVO thaliItemQtyQueryRpcParamVO);

    @PostMapping("/cal")
    List<ThaliItemCalPreSellQtyRpcRespVO> calThaliItemPreSellQty(@RequestBody ThaliItemCalPreSellQtyRpcParamVO thaliItemCalPreSellQtyRpcParamVO);
}
