package com.elitesland.inv.dto.cost;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("成本核算详情")
public class InvCostDetailRpcDTO implements Serializable {

    @ApiModelProperty("流水id")
    private Long ioId;

    @Comment("成本计算时间")
    private LocalDateTime costedDate;

    @Comment("出入库时间")
    private LocalDateTime ioDate;

    @Comment("记账时间")
    private LocalDateTime finDate;

    @ApiModelProperty("场景码")
    private String sceneCode;

    @ApiModelProperty("场景描述")
    private String sceneDesc;

    @ApiModelProperty("操作码")
    private String ioCode;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("组织id")
    private Long buId;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("附加1")
    private String deter1;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("附加3")
    private String deter3;

    @ApiModelProperty("附加4")
    private String deter4;

    @ApiModelProperty("附加5")
    private String deter5;

    @ApiModelProperty("附加6")
    private String deter6;

    @ApiModelProperty("附加7")
    private String deter7;

    @ApiModelProperty("货位")
    private String whLoc;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("当期成本单价")
    private BigDecimal costPrice;

    @ApiModelProperty("当期发生数量")
    private BigDecimal primaryQty;

    @ApiModelProperty("当期成本金额")
    private BigDecimal costAmt;

    @ApiModelProperty("期末成本单价")
    private BigDecimal newCost;

    @ApiModelProperty("期末数量")
    private BigDecimal newQty;

    @ApiModelProperty("期末成本金额")
    private BigDecimal newAmt;

    @ApiModelProperty("参与性/继承性")
    private String costType;

    @ApiModelProperty("参与性/继承性")
    private String costTypeName;

    @ApiModelProperty("成本计算递增序列")
    private Integer costDetailFlag;

    @ApiModelProperty("场景配置行id")
    private Long sceneCodeLineId;

    @ApiModelProperty("来源单号")
    private String srcDocNo;
}
