package com.elitesland.inv.dto.invstk;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 库存操作返回结果
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-6-03
 */
@Data
@ApiModel(value = "库存操作返回结果）", description = "库存操作返回结果")
public class InvStkCommonResultRpcDto implements Serializable {

    private static final long serialVersionUID = 4259227812435381838L;

    @ApiModelProperty("操作结果")
    private Boolean isSuccessful;

    @ApiModelProperty("消息")
    private String message;

    @ApiModelProperty("出库信息")
    private List<InvStkQtyResultRpcDTO> result;


}