package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订货小程序查询库存返回
 */
@Data
@ApiModel("订货小程序查询库存返回")
public class InvStkStoreMpRpcParam implements Serializable {

    private static final long serialVersionUID = -6587906375365034965L;

    @ApiModelProperty("商品及单位集合")
    private List<InvStkItemUomRpcDtoParam> invStkItemUomParams;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库集合")
    private List<Long> whIds;

}
