package com.elitesland.inv.dto.sc;

import com.elitesland.inv.util.SourceTypeEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * @author jeesie
 * @description:
 * @datetime 2024年 01月 08日 16:39
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScSaveRpcDto", description = "商品变更单保存")
public class InvScSaveRpcDTO implements Serializable {

    private static final long serialVersionUID = -2395663037781042857L;

    @ApiModelProperty("公司编号")
    @NotBlank(message = "公司编码不能为空")
    private String ouCode;

    @ApiModelProperty("来源系统类型")
    @NotNull(message = "来源系统类型不能为空")
    private SourceTypeEnum sourceType;

    @ApiModelProperty("唯一请求ID（每次请求生成唯一ID）")
    @NotBlank(message = "请求ID不能为空")
    private String requestId;

    @ApiModelProperty("NC仓库编码")
    @NotBlank(message = "NC仓库编码不能为空")
    private String otherWhCode;

    @ApiModelProperty("外部系统仓库类型")
    @NotBlank(message = "外部系统仓库类型不能为空")
    private String otherWhType;

    @ApiModelProperty("原因码")
    private String reasonCode;

    @ApiModelProperty("总数量")
    @NotNull(message = "调整数量不能为空")
    private BigDecimal qty;

    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("单据明细保存信息")
    private List<InvScdSaveRpcDTO> invScDSaveVOList;


}
