package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.expesne.ExpenseReCalParamRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Auther: Mark
 * @Date: 2024/9/23 15:46
 * @Description:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ExpenseCalServiceProvider.PATH)
public interface ExpenseCalServiceProvider {

    String PATH = "/expenseCalService";

    /**
     * 重新计算指定调拨单的台账
     */
    @PostMapping("/reCal")
    ApiResult<String> reCal(@RequestBody ExpenseReCalParamRpcDTO expenseReCalParamRpcDTO);
}
