package com.elitesland.inv.provider;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.inv.dto.out.*;

import java.util.*;
import java.util.stream.Collectors;

public class InvWmsInfoClient {

    private static InvWmsProvider invWmsProvider;
    private static UdcProvider udcProvider;

    private static void init() {
        invWmsProvider = SpringUtil.getBean(InvWmsProvider.class);
        udcProvider = SpringUtil.getBean(UdcProvider.class);
    }

    public static List<Long> findRelateDocFromIdo(InvOutSysQueryParam queryParam) {
        init();

        InvOutSysQueryDTO queryDTO = InvOutSysQueryDTO.build(queryParam);
        if (!queryDTO.hasParam()) {
            return null;
        }
        List<Long> result = invWmsProvider.findRelateDocFromIdo(queryDTO).computeData();
        return result == null ? new ArrayList<>() : result;
    }

    public static List<Long> findRelateDocFromOdo(InvOutSysQueryParam queryParam) {
        init();

        InvOutSysQueryDTO queryDTO = InvOutSysQueryDTO.build(queryParam);
        if (!queryDTO.hasParam()) {
            return null;
        }
        List<Long> result = invWmsProvider.findRelateDocFromOdo(queryDTO).computeData();
        return result == null ? new ArrayList<>() : result;
    }

    public static void refreshWmsInfoFromIdo(List<? extends InvOutSysVO> sysVOS) {
        if (CollectionUtil.isEmpty(sysVOS)) {
            return;
        }

        init();
        List<Long> ids = sysVOS.stream().filter(i -> i != null).map(i -> i.getInvDocId()).collect(Collectors.toList());
        List<InvOutSysDTO> outSysDTOFromIdo = invWmsProvider.findOutSysDTOFromIdo(ids).computeData();
        refreshWmsInfo(sysVOS, outSysDTOFromIdo);
    }

    public static void refreshWmsInfoFromOdo(List<? extends InvOutSysVO> sysVOS) {
        if (CollectionUtil.isEmpty(sysVOS)) {
            return;
        }

        init();
        List<Long> ids = sysVOS.stream().filter(i -> i != null).map(i -> i.getInvDocId()).collect(Collectors.toList());
        List<InvOutSysDTO> outSysDTOFromOdo = invWmsProvider.findOutSysDTOFromOdo(ids).computeData();
        refreshWmsInfo(sysVOS, outSysDTOFromOdo);
    }

    public static void refreshWmsInfo(List<? extends InvOutSysVO> sysVOS, List<InvOutSysDTO> sysDTOS) {
        if (CollectionUtil.isEmpty(sysDTOS)) {
            return;
        }

        init();
        Map<Long, InvOutSysDTO> sysInfoMap = sysDTOS.stream().collect(Collectors.toMap(i -> i.getInvDocId(), i -> i, (o, n) -> n));
        Map<String, Map<String, String>> uomMap = udcProvider.getValueMapByUdcCode("yst-supp", Set.of("EXTERNAL_SYNC_STATUS", "EXTERNAL_FEEDBACK_STATUS"));

        for (InvOutSysVO sysVO : sysVOS) {
            InvOutSysDTO invOutSysDTO = sysInfoMap.get(sysVO.getInvDocId());
            if (invOutSysDTO != null) {
                sysVO.setWmsCancelLog(invOutSysDTO.getWmsCancelLog());
                sysVO.setWmsFeedbackStatus(invOutSysDTO.getWmsFeedbackStatus());
                sysVO.setWmsStatus(invOutSysDTO.getWmsStatus());
                sysVO.setWmsTime(invOutSysDTO.getWmsTime());
                sysVO.setWmsLog(invOutSysDTO.getWmsLog());
                sysVO.setWmsCancelTime(invOutSysDTO.getWmsCancelTime());
                sysVO.setWmsStatusName(uomMap.getOrDefault("EXTERNAL_SYNC_STATUS", new HashMap<>()).get(invOutSysDTO.getWmsStatus()));
                sysVO.setWmsFeedbackStatusName(uomMap.getOrDefault("EXTERNAL_FEEDBACK_STATUS", new HashMap<>()).get(invOutSysDTO.getWmsFeedbackStatus()));
            }
        }
    }

    public static void refreshWms2Info(List<? extends InvOutSysVO2> sysVOS, List<InvOutSysDTO> sysDTOS) {
        if (CollectionUtil.isEmpty(sysDTOS)) {
            return;
        }

        init();
        Map<Long, InvOutSysDTO> sysInfoMap = sysDTOS.stream().collect(Collectors.toMap(i -> i.getInvDocId(), i -> i, (o, n) -> n));
        Map<String, Map<String, String>> uomMap = udcProvider.getValueMapByUdcCode("yst-supp", Set.of("EXTERNAL_SYNC_STATUS", "EXTERNAL_FEEDBACK_STATUS"));

        for (InvOutSysVO2 sysVO : sysVOS) {
            InvOutSysDTO invOutSysDTO = sysInfoMap.get(sysVO.getInvDocId());
            if (invOutSysDTO != null) {
                sysVO.setWmsCancelLog2(invOutSysDTO.getWmsCancelLog());
                sysVO.setWmsFeedbackStatus2(invOutSysDTO.getWmsFeedbackStatus());
                sysVO.setWmsStatus2(invOutSysDTO.getWmsStatus());
                sysVO.setWmsTime2(invOutSysDTO.getWmsTime());
                sysVO.setWmsLog2(invOutSysDTO.getWmsLog());
                sysVO.setWmsCancelTime2(invOutSysDTO.getWmsCancelTime());
                sysVO.setWmsStatus2Name(uomMap.getOrDefault("EXTERNAL_SYNC_STATUS", new HashMap<>()).get(invOutSysDTO.getWmsStatus()));
                sysVO.setWmsFeedbackStatus2Name(uomMap.getOrDefault("EXTERNAL_FEEDBACK_STATUS", new HashMap<>()).get(invOutSysDTO.getWmsFeedbackStatus()));
            }
        }
    }
}
