package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description: 仓库商品库存汇总返回
 * @datetime 2024年 11月 04日 14:46
 * @version: 1.0
 */
@Data
public class InvWhItemTotalStkRpcDTO implements Serializable {
    private static final long serialVersionUID = 4136053250554530147L;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("可用量(基本单位)")
    private BigDecimal avalQty;

    @ApiModelProperty("可用量(辅助单位)")
    private BigDecimal avalQty2;

    @ApiModelProperty("可用量(领用单位)")
    private BigDecimal usageAvalQty;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("辅助单位(小程序显示)")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("领用单位")
    private String usageUom;
    private String usageUomName;

    @ApiModelProperty("领用单位转换系数")
    private BigDecimal usageUomRatio;

    @ApiModelProperty("辅助单位转换系数")
    private BigDecimal uomRatio;


}
