package com.elitesland.inv.dto.invwh;

import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 09月 13日 18:28
 * @version: 1.0
 */
@Data
@ApiModel( description = "退货仓查询条件")
public class InvWhReVarturyRpcDtoParam implements Serializable {

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "ouId 不能为空")
    private Long ouId;

    @ApiModelProperty("内置功能区类型枚举")
    private InvDeter2TypeEnum deter2TypeEnum;


}
