package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.cost.InvCostDetailRpcDTO;
import com.elitesland.inv.dto.cost.InvCostDetailRpcDtoParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author chaofeng.xia
 * @date 2024/9/3 16:46
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvCostProvider.PATH)
public interface InvCostProvider {

    String PATH = "/invCost";

    /**
     * 查询结算核算明细
     * @param param 查询条件
     * @return 结果
     */
    @PostMapping("/findLatestCostDetail")
    ApiResult<List<InvCostDetailRpcDTO>> findLatestCostDetailByParam(@RequestBody InvCostDetailRpcDtoParam param);

}
