package com.elitesland.inv.dto.invTrn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "StoreRtnRpcDTO", description = "门店退货参数")
public class StoreRtnRpcDTO implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    @ApiModelProperty("业务单据id")
    private Long docId;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("发起退货时传入，退货确认时为空")
    private String note;

    @ApiModelProperty(value = "退货图片")
    private List<String> picList;

    @ApiModelProperty("配送方式")
    private String deliveryMethod;

    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("物流配送人")
    private String logisContactName;

    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("明细")
    private List<StoreRtnRpcDTODetail> details;

    @Data
    public static class StoreRtnRpcDTODetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("明细id")
        private Long id;

        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("实收数量")
        private BigDecimal qty;
    }
}
