package com.elitesland.inv.dto.thaliItem;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Mark
 * @description:
 * @datetime 2024年 09月 10日 14:10
 * @version: 1.0
 */
@Data
@ApiModel(value = "ThaliItemCalPreSellQtyRpcRespVO ", description = "菜品可售数量结果对象")
public class ThaliItemCalPreSellQtyRpcRespVO implements Serializable {
    private static final long serialVersionUID = -4231549209643665171L;

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码为空")
    private String storeCode;

    @ApiModelProperty("菜品编码")
    private String thaliItemCode;

    @ApiModelProperty("规格值编码")
    private String sizeCode;

    @ApiModelProperty("可售数量")
    private BigDecimal qty;

}
