package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.companyAndCust.CompanyAndCustRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Auther: Mark
 * @Date: 2024/8/26 10:58
 * @Description:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + InvCompanyAndCustProvider.PATH)
public interface InvCompanyAndCustProvider {

    String PATH = "/ouAndCust";

    @GetMapping("/getByDocNo")
    CompanyAndCustRpcDTO getFromCompanyAndToCustomer(@RequestParam("docNo") String docNo);

    @GetMapping("/getByTrnDocNo")
    CompanyAndCustRpcDTO getFromCompanyAndToCustomerByTrnNo(@RequestParam("docNo") String docNo);
}
