package com.elitesland.inv.dto.invwh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "inv_wh", description = "仓库")
public class InvWhRpcSimpleDTO implements Serializable {
    private static final long serialVersionUID = -84413014701696628L;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv",mod = "WH_TYPE")
    private String whType;

    @ApiModelProperty("外部仓库编码")
    private String outWhCode;

    @ApiModelProperty("外部货主编码")
    private String outOwnerCode;

    @ApiModelProperty("外部系统类型")
    private String outSysType;

    private Long addrNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("工厂ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long factoryId;

    @ApiModelProperty("工厂编码")
    private String factoryCode;

}
