package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invwh.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-3 14:00:15
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvWhProvider.PATH)
public interface InvWhProvider {
    String PATH = "/invWh";


    /**
     * 入参：仓库、编码、仓库类型
     * 查询仓库及库区信息
     * @param param
     * @return
     */
    @GetMapping("/findWhAreaDTO")
    ApiResult<List<InvWhDetailRpcDTO>> findWhAreaDTOByParam(@RequestBody InvWhRpcDtoParam param);

    /**
     * 入参：公司 是否越库 供应商编码
     * 查询公司对应供应商的越库仓
     * @param param
     * @return
     */
    @GetMapping("/findCrossWhAreaDTOByParam")
    ApiResult<List<InvWhDetailRpcDTO>> findCrossWhAreaDTOByParam(@RequestBody InvWhRpcDtoParam param);



    /**
     * 查询仓库：只返回仓库信息，不返回库区(功能区)；查询效率高
     * 入参：仓库、编码、仓库类型、功能区类型
     * 返回数据字段不是很全
     * @param param
     * @return
     */
    @GetMapping("/findWhDTO")
    ApiResult<List<InvWhRpcDTO>> findWhDTOByParam(@RequestBody @NotNull(message = "参数值不能为空") InvWhRpcDtoParam param);


    /**
     * 查询根据省市区配送范围来查询仓库
     * 入参：入参：仓库、编码、仓库类型、配送范围-省市区编码、公司
     * 返回：仓库及库区信息
     * @param param
     * @return List<InvWhPartRpcDTO>
     */
    @GetMapping("/findWhByDelivery")
    List<InvWhRpcDTO> findWhByDeliveryParam(@RequestBody InvWhDeliveryRpcDtoParam param);

    /**
     * 根据公司查询虚拟退货仓
     * @return
     */
    @PostMapping("/finsReVarturyWh")
    ApiResult<InvWhDetailRpcDTO> finsReVarturyWh(@RequestBody InvWhReVarturyRpcDtoParam reVarturyRpcDtoParam);

    @PostMapping("/querySimple")
    ApiResult<List<InvWhRpcSimpleDTO>> querySimple(@RequestBody List<Long> whIds);

    @GetMapping("/queryWhByOutSys")
    ApiResult<List<Long>> queryWhByOutSys(@RequestParam(value = "outWhCode", required = false) String outWhCode, @RequestParam(value = "outOwnerCode", required = false) String outOwnerCode);

    @GetMapping("/queryOutWh")
    ApiResult<List<InvWhRpcSimpleDTO>> queryOutWh();

    @PostMapping("/findByWhCodes")
    ApiResult<List<InvWhRpcSimpleDTO>> findSimpleWhByWhCodes(@RequestBody List<String> whCodes);
}
