package com.elitesland.inv.dto.ido;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "InvIdoDSaveRpcDTO", description = "入库单明细保存")
public class InvIdoDSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -956075481038757183L;
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("行状态")
    private String lineStatus;

    @ApiModelProperty("行类型")
    private String lineType;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("品牌")
    private String itemBrand;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("限定5")
    private String deter5;

    @ApiModelProperty("限定6")
    private String deter6;

    @ApiModelProperty("限定7")
    private String deter7;

    @ApiModelProperty("限定8")
    private String deter8;

    @ApiModelProperty("SPUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("要求发货数量")
    private BigDecimal demandQty;

    @ApiModelProperty("原始批次号")
    private String oLotNo;

    @ApiModelProperty("实发数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("包装数量")
    private BigDecimal packQty;

    @ApiModelProperty("包装单位")
    private String packUom;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("已签收金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("关联单据2类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;

    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("关联单据类别")
    private String relateDoc3Cls;

    @ApiModelProperty("关联单据3ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc3Id;

    @ApiModelProperty("关联单据3编号")
    private String relateDoc3No;

    @ApiModelProperty("关联单据3明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc3Did;

    @ApiModelProperty("关联单据3行号")
    private BigDecimal relateDoc3Lineno;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("es4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("limit1")
    private String limit1;
}
