package com.elitesland.inv.dto.boh;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "库存转移详情")
public class StoreOrderDRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("转移单明细ID")
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("出库批次")
    private String outLotNo;

    @ApiModelProperty("入库批次")
    private String inLotNo;

    @ApiModelProperty("计划数量")
    private BigDecimal qty;

    @ApiModelProperty("出库数量")
    private BigDecimal outQty;

    @ApiModelProperty("入库数量")
    private BigDecimal inQty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("出库存状态")
    private String outLimit1;

    @ApiModelProperty("计划入库存状态")
    private String planInLimit1;

    @ApiModelProperty("入库存状态")
    private String inLimit1;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("关联明细id")
    private Long relateDocDid;
}