package com.elitesland.inv.dto.boh;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "StoreRtnApplyResult", description = "门店退货申请结果")
public class StoreRtnApplyResult implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    @ApiModelProperty("业务单据id")
    private Long docId;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("商品集合")
    private List<OrderItem> items;

    @Data
    public static class OrderItem implements Serializable {
        @ApiModelProperty("业务单明细id")
        private Long did;
        @ApiModelProperty("业务单据明细发货数量")
        private BigDecimal qty;
        @ApiModelProperty("商品id")
        private Long itemId;
        private Long relateDocDid;
    }
}
