package com.elitesland.inv.dto.invIo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("库存流水返回")
public class InvIoRpcDTO implements Serializable {
    private static final long serialVersionUID = 7077536379631248097L;

    @ApiModelProperty("库存流水ID")
    private Long id;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty;

    @ApiModelProperty("基本单位")
    private String uom;

    @ApiModelProperty("转换单位数量")
    private BigDecimal convertQty;

    @ApiModelProperty("转换单位")
    private String convertUom;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("来源单据明细ID")
    private Long srcDocDid;

    @ApiModelProperty("来源单据")
    private String srcDocNo;
}
