package com.elitesland.inv.dto.sc;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 01月 08日 17:53
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScDSaveRpcDTO", description = "商品变更单明细保存")
public class InvScdSaveRpcDTO implements Serializable {

    private static final long serialVersionUID = -2395663037781042857L;

    @ApiModelProperty("品项编号")
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("调整数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("商品原状态")
    @NotBlank(message = "商品原状态不能为空")
    private String originLimit1;

    @ApiModelProperty("商品新状态")
    @NotBlank(message = "商品新状态不能为空")
    private String newLimit1;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("入库日期")
    private LocalDateTime stkInDate;

    @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;

    @ApiModelProperty("限定字段2")
    private String limit2;

    @ApiModelProperty("限定字段3")
    private String limit3;


}
