package com.elitesland.inv.provider;


import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.inv.dto.invDes.resp.InvDespatchRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie.jiang
 * @date 2023/02/20
 * <p>
 *    发运地查询
 * </p>
 */


@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvDespatchProvider.PATH)
public interface InvDespatchProvider {

    String PATH = "/invDespatch";

    @PostMapping("/findDespatchByParam")
    List<InvDespatchRpcDTO> findDespatchRpcByParam(@RequestBody InvDespatchRpcParam param);


}
