package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 订货小程序查询库存返回
 */
@Data
@ApiModel("日结单信息返回")
public class InvStoreSettleRpcDTO implements Serializable {

    private static final long serialVersionUID = -6387906375365034965L;

    @ApiModelProperty("日结单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("状态")
    private String docStatus;

    @ApiModelProperty("类型")
    private String docType;

    @ApiModelProperty("门店编号")
    private String storeCode;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("日结日期")
    private LocalDateTime settleDate;
}
