package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invwh.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-3 14:00:15
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvWhNewProvider.PATH)
public interface InvWhNewProvider {
    String PATH = "/invWh";

    /**
     * 根据公司查询虚拟退货仓
     * @return
     */
    @PostMapping("/createWh")
    ApiResult<Long> createWh(@RequestBody InvWhSaveRpcDTO invWhSaveRpcDTO);

    @PostMapping("/updateStoreWhRecvAddr")
    ApiResult<Long> updateStoreWhRecvAddr(@RequestBody InvWhRecvAddrSaveRpcDTO whRecvAddrSaveRpcDTO);

}
