package com.elitesland.inv.dto.invTro;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;


@Data
@ApiModel(value = "InvTroDRpcDTO", description = "库存调拨订单明细返回")
public class InvTroDRpcDTO implements Serializable {

    private static final long serialVersionUID = 8440216530882128390L;

    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "行状态")
    private String lineStatus;

    @ApiModelProperty(value = "行类型")
    private String lineType;

    @ApiModelProperty(value = "从公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long oOuId;

    @ApiModelProperty(value = "到公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long iOuId;

    @ApiModelProperty(value = "从功能区 [UDC]INV:FUNC_TYPE")
    private String oDeter2;
    private String oDeter2Name;

    @ApiModelProperty(value = "到功能区 [UDC]INV:FUNC_TYPE")
    private String iDeter2;

    @ApiModelProperty(value = "从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long oWhId;

    @ApiModelProperty(value = "从仓库编码")
    private String oWhCode;

    @ApiModelProperty(value = "到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long iWhId;

    @ApiModelProperty(value = "至仓库编号")
    private String iWhCode;


    @ApiModelProperty(value = "从库存状态")
    private String olimit1;

    @ApiModelProperty(value = "至库存状态")
    private String ilimit1;

    @ApiModelProperty("商品SKU物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;
    @ApiModelProperty("商品SKU物料类型名")
    private String itemType2Name;

    @ApiModelProperty(value = "品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名")
    private String itemName;

    @ApiModelProperty(value = "订单数量（基本单位）")
    private BigDecimal troQty;

    @ApiModelProperty(value = "计划数量（基本单位）")
    private BigDecimal planQty;

    @ApiModelProperty(value = "订单数量(辅助单位)")
    private BigDecimal troQty2;

    @ApiModelProperty(value = "单位(辅助单位)")
    private String uom2;

    @ApiModelProperty(value = "单位（基本单位）")
    private String uom;

    @ApiModelProperty(value = "单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty(value = "锁定数量（基本单位）")
    private BigDecimal lockQty;

    @ApiModelProperty(value = "收货数量（基本单位）")
    private BigDecimal inQty;

    @ApiModelProperty(value = "发货数量（基本单位）")
    private BigDecimal outQty;

    @ApiModelProperty(value = "取消数量（基本单位）")
    private BigDecimal cancelQty;

    @ApiModelProperty(value = "退货数量（基本单位）")
    private BigDecimal rtnQty;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty("含税总价（包含项目服务费）")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "未税单价")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "税率，根据商品主档获取")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "金额")
    private BigDecimal lastPathSaleAmt;

    @ApiModelProperty(value = "关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty(value = "关联单据类型")
    private String relateDocType;

    @ApiModelProperty(value = "关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty(value = "关联单据编号")
    private String relateDocNo;

    @ApiModelProperty(value = "关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;

    @ApiModelProperty(value = "关联单据明细2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;

    @ApiModelProperty("有原单明细ID")
    private Long relate2Did;

    @ApiModelProperty(value = "关联单据行号")
    private Float relateDocLineno;

    @ApiModelProperty(value = "批次号")
    private String lotNo;

    @ApiModelProperty(value = "赠品")
    private Boolean giftLineFlag;

    @ApiModelProperty("返利账户占用金额")
    private BigDecimal rebateOccAmt;

    @ApiModelProperty("储值账户占用金额")
    private BigDecimal storedOccAmt;

    @ApiModelProperty("信用账户占用金额")
    private BigDecimal creditOccAmt;

    @ApiModelProperty("返利账户累计金额")
    private BigDecimal rebateAddAmt;

    @ApiModelProperty("储值账户累计金额")
    private BigDecimal storedAddAmt;

    @ApiModelProperty("信用账户累计金额")
    private BigDecimal creditAddAmt;

    @ApiModelProperty("返利账户退货金额")
    private BigDecimal rebateBackAmt;

    @ApiModelProperty("储值账户退货金额")
    private BigDecimal storedBackAmt;

    @ApiModelProperty("信用账户退货金额")
    private BigDecimal creditBackAmt;

    @ApiModelProperty("储值账户关闭金额")
    private BigDecimal storedCloseAmt;

    @ApiModelProperty("返利账户关闭金额")
    private BigDecimal rebateCloseAmt;

    @ApiModelProperty("信用账户关闭金额")
    private BigDecimal creditCloseAmt;

}