package com.elitesland.inv.dto.invwh;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 仓库(OrgWh)实体类
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:00:48
 */

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:00:48
 */
@Data
@ApiModel(value = "inv_wh", description = "仓库保存rpc接口")
public class InvWhSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -51945385646801579L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    private List<Long> ids;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;

    @ApiModelProperty("公司编码")
    private String ouCode;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    /**
     * 所有者地址号 用于寄售库和VMI库，DCH不用
     */
    @ApiModelProperty("所有者地址号 用于寄售库和VMI库，DCH不用")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ownerAddrNo;
    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;
    /**
     * 仓库名称2
     */
    @ApiModelProperty("仓库名称2")
    private String whName2;
    /**
     * 简称
     */
    @ApiModelProperty("简称")
    private String whAbbr;
    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;
    /**
     * 仓库类型2
     */
    @ApiModelProperty("仓库类型2")
    private String whType2;
    /**
     * 仓库类型3
     */
    @ApiModelProperty("仓库类型3")
    private String whType3;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;

    @ApiModelProperty("外部仓库类型编码")
    private String otherWhCode;

    @ApiModelProperty("所属组织类型")
    private String belongBuType;

    @ApiModelProperty("所属组织")
    private String belongBuId;
    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    private String whStatus;
    /**
     * 是否3PL仓库
     */
    @ApiModelProperty("是否3PL仓库")
    private Integer thirdplFlag;

    @ApiModelProperty("是否退货仓")
    private Integer tuihuoFlag;

    /**
     * 营业厅编码
     */
    @ApiModelProperty("营业厅编码")
    private String businessCode;

    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private List<String> deliveryList;
    private List<String> deliveryNameList;
    /**
     * 配送范围
     */
    @ApiModelProperty("配送范围")
    private String deliveryArea;

    /**
     * 配送范围
     */
    @ApiModelProperty("配送范围")
    private List<InvWhDeliverySaveRpcDTO> deliveryAreas;

    /**
     * erp仓库编码
     */
    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    /**
     * erp仓库名
     */
    @ApiModelProperty("erp仓库名称")
    private String erpName;

    /**
     * 物理仓编号
     */
    @ApiModelProperty("物理仓编号")
    private String physicalWhCode;
    /**
     * 地址号 仓库本身的地址号
     */
    @ApiModelProperty("地址号 仓库本身的地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;
    /**
     * 地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.
     */
    @ApiModelProperty("地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addressId;
    /**
     * 上级ID
     */
    @ApiModelProperty("上级ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;
    /**
     * 路径
     */
    @ApiModelProperty("路径")
    private String whPath;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 仓库属性
     */
    @ApiModelProperty("ES1 - 仓库属性")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * ES6
     */
    @ApiModelProperty("允许批次负可用")
    private String es6;
    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    private String es7;
    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    private String es8;
    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;
    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private String es10;
    /**
     * 采购仓库/销售仓库
     */
    @ApiModelProperty("采购仓库/销售仓库")
    private String ee1;
    /**
     * 是否有WMS
     */
    @ApiModelProperty("是否有WMS")
    private String ee2;
    /**
     * EE3
     */
    @ApiModelProperty("EE3")
    private String ee3;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime = LocalDateTime.now();
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    //页面
    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("详细地址")
    private String detailaddr;

    /**
     * 联系人邮箱
     */
    @ApiModelProperty("仓库联系人邮箱")
    private String email;

    @ApiModelProperty("仓库联系人")
    private String contPerson;

    @ApiModelProperty("仓库联系人电话")
    private String tel;
    /**
     * 仓库面积
     */
    @ApiModelProperty("仓库面积")
    private Double area;
    /**
     * 仓库结构
     */
    @ApiModelProperty("仓库结构")
    private String structure;

    @ApiModelProperty("是否装卸平台")
    private Integer plateformFlag;

    /**
     * 仓库固定资产
     */
    @ApiModelProperty("仓库固定资产")
    private String fixedAssets;

    /**
     * 附件标识
     */
    @ApiModelProperty("附件标识fileCode")
    private String fileCode;

    @ApiModelProperty("京东仓库关联码")
    private String jdrelateCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京云仓编码")
    private String jdwhCode;

    @ApiModelProperty("不良京云仓")
    private Integer jdbadFlag;

    @ApiModelProperty("库区")
    private List<InvWhAreaSaveRpcDTO> orgWhAreaCreateParamList;

    @ApiModelProperty("所属发运地id")
    Long desId;

    @ApiModelProperty("所属发运地编码")
    String desCode;
    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    /**
     * 层级
     */
    @ApiModelProperty(value = "层级")
    private Integer level;

    @ApiModelProperty(value = "仓库优先级")
    private Integer priority;
    @ApiModelProperty(value = "对接外部仓库 1：是 0：否")
    private Boolean joinOutWh;
    @ApiModelProperty(value = "外部仓库货主")
    private String outWhOwer;


    @ApiModelProperty(value = "对接外部erp 1：是 0：否")
    private Boolean erpJoinOutWh;

    @ApiModelProperty("外部erp仓库类型")
    private String erpWhType;

    @ApiModelProperty("外部erp仓库类型编码")
    private String erpWhCode;

    @ApiModelProperty("外部erp仓库货主")
    private String erpOutWhOwer;
    @ApiModelProperty("外部是否对账(wms)")
    private Boolean outAccountRecordFlag;
    @ApiModelProperty("外部ERP是否对账")
    private Boolean erpAccountRecordFlag;

    @ApiModelProperty("是否越库仓")
    private Boolean crossFlag;

    @ApiModelProperty("对应供应商")
    String suppCode;

    @ApiModelProperty("退货虚拟仓")
    Boolean reVarturyFlag;

    @ApiModelProperty("存储条件 UDC:yst-supp:STORE_CONDITION")
    String storeCondition;

    @ApiModelProperty("存储条件 UDC:yst-supp:STORE_CONDITION")
    List<String> storeConditions;

    @ApiModelProperty("仓库管理员（员工编码）")
    String managerEmpCode;

    @ApiModelProperty("仓库管理员（员工姓名）")
    String managerEmpName;

    @ApiModelProperty("承运商编码列表")
    private List<String> carrierList;

    @ApiModelProperty("工厂ID")
    private Long factoryId;

    @ApiModelProperty("工厂编码")
    private String factoryCode;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("是否自动收货")
    private Boolean autoRecvFlag;

    @ApiModelProperty("仓库收货时间")
    private String recvDateTime;
}
