package com.elitesland.inv.dto.odo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class InvOdoRpcDto implements Serializable {
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("来源系统")
    private String systemSource;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("单据日期")
    private LocalDateTime docDate;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("单据状态 [UDC]ODO:ODO_STATUS")
    private String docStatus;

    @ApiModelProperty("发货时间")
    private LocalDateTime shipmentDate;

    @ApiModelProperty("要求发货时间")
    private LocalDateTime demandDate;

    @ApiModelProperty("BUID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员员工编号")
    private String agentEmpCode;

    @ApiModelProperty("业务员名")
    private String agentEmpName;

    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;

    @ApiModelProperty("承运信息")
    private String deliveryDesc;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("签收用户ID")
    private Long confirmUserId;

    @ApiModelProperty("签收人")
    private String confirmUserName;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("收货地址联系人")
    private String recvContactName;

    @ApiModelProperty("收货地址电话")
    private String recvContactTel;

    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("关联单据类别")
    private String relateDocCls;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据2类别")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据3类别")
    private String relateDoc3Cls;

    @ApiModelProperty("关联单据3ID")
    private Long relateDoc3Id;

    @ApiModelProperty("关联单据3编号")
    private String relateDoc3No;

    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("物流费用")
    private BigDecimal logisFee;

    @ApiModelProperty("发货时间")
    private LocalDateTime logisTime;

    @ApiModelProperty("物流配送人")
    private String logisContactName;

    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("操作状态标志")
    private Integer optFlag;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("作废标志")
    String abortStatus = "0";

    @ApiModelProperty("custCode")
    String custCode;

    @ApiModelProperty("custName")
    String custName;

    @ApiModelProperty("custCode")
    String suppCode;

    @ApiModelProperty("custName")
    String suppName;

    @ApiModelProperty("发货地址号")
    private Long deliverAddrNo;

    @ApiModelProperty("发货联系人")
    private String deliverContactName;

    @ApiModelProperty("发货联系人电话")
    private String deliverContactTel;

    @ApiModelProperty("发货联系人email")
    private String deliverContactEmail;

    @ApiModelProperty("发货国家")
    private String deliverCountry;

    @ApiModelProperty("发货省份")
    private String deliverProvince;

    @ApiModelProperty("发货城市")
    private String deliverCity;

    @ApiModelProperty("发货乡镇")
    private String deliverCounty;

    @ApiModelProperty("发货街道")
    private String deliverStreet;

    @ApiModelProperty("发货详细地址")
    private String deliverDetailaddr;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;

    @ApiModelProperty("最后修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("wms 系统类型")
    private String outWhSysType;

    @ApiModelProperty("外部仓库货主(wms)")
    private String outWhOwer;

    @ApiModelProperty("外部WMS仓库类型编码")
    private String otherWhCode;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("外部系统单号")
    private String outDocNo;

    @ApiModelProperty("往来单位编码")
    private String erpUserCode;

    @ApiModelProperty("往来单位名称")
    private String erpUserName;

    @ApiModelProperty("期望到货日期")
    private LocalDateTime expectArriveDate;

    private List<InvOdoDRpcDto> details;

    @Data
    public static class InvOdoDRpcDto implements Serializable {
        @ApiModelProperty("ID")
        private Long id;

        @ApiModelProperty("原明细ID")
        private Long oCopyId;

        @ApiModelProperty("行号")
        private BigDecimal lineNo;

        @ApiModelProperty("行状态")
        private String lineStatus;

        @ApiModelProperty("行类型")
        private String lineType;

        @ApiModelProperty("仓库ID")
        private Long whId;

        @ApiModelProperty("仓库编码")
        private String whCode;

        @ApiModelProperty("批次")
        private String lotNo;

        @ApiModelProperty("品项ID")
        private Long itemId;

        @ApiModelProperty("商品编号")
        private String itemCode;

        @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
        private String deter2;

        @ApiModelProperty("要求发货数量(辅助单位)")
        private BigDecimal demandQty;

        @ApiModelProperty("原始批次号")
        private String oLotNo;

        @ApiModelProperty("实发数量（基本单位）")
        private BigDecimal qty;

        @ApiModelProperty("实时实发数量（基本单位）")
        private BigDecimal qty2;

        @ApiModelProperty("基本单位")
        private String uom;

        @ApiModelProperty("签收数量")
        private BigDecimal confirmQty;

        @ApiModelProperty("已签收金额")
        private BigDecimal confirmAmt;

        @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
        private String relateDocCls;

        @ApiModelProperty("关联单据ID")
        private Long relateDocId;

        @ApiModelProperty("关联单据编号")
        private String relateDocNo;

        @ApiModelProperty("关联单据明细ID")
        private Long relateDocDid;

        @ApiModelProperty("关联单据行号")
        private BigDecimal relateDocLineno;

        @ApiModelProperty("关联单据2类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
        private String relateDoc2Cls;

        @ApiModelProperty("关联单据2ID")
        private Long relateDoc2Id;

        @ApiModelProperty("关联单据2编号")
        private String relateDoc2No;

        @ApiModelProperty("关联单据2明细ID")
        private Long relateDoc2Did;

        @ApiModelProperty("关联单据2行号")
        private BigDecimal relateDoc2Lineno;

        @ApiModelProperty("关联单据类别")
        private String relateDoc3Cls;

        @ApiModelProperty("关联单据3ID")
        private Long relateDoc3Id;

        @ApiModelProperty("关联单据3编号")
        private String relateDoc3No;

        @ApiModelProperty("关联单据3明细ID")
        private Long relateDoc3Did;

        @ApiModelProperty("关联单据3行号")
        private BigDecimal relateDoc3Lineno;

        @ApiModelProperty("limit1")
        private String limit1;

        @ApiModelProperty("limit2")
        private String limit2;

        @ApiModelProperty("wms总发货数量")
        private BigDecimal wmsQty;

        @ApiModelProperty("单位转换率")
        private BigDecimal uomRatio;

        @ApiModelProperty("辅助单位")
        private String packUom;

        @ApiModelProperty("实发数量(辅助单位)")
        private BigDecimal packQty;

        @ApiModelProperty("要求发货数量(辅助单位)")
        private BigDecimal demandQty2;

        @ApiModelProperty(name = "有效小数位")
        private Integer places;

        @ApiModelProperty("基础单位单价")
        private BigDecimal price;

        @ApiModelProperty("实际单价")
        private BigDecimal mprice;

        @ApiModelProperty("金额")
        private BigDecimal money;

        @ApiModelProperty("含税单价")
        private BigDecimal taxedPrice;

        @ApiModelProperty("实际含税单价")
        private BigDecimal mtaxedPrice;

        @ApiModelProperty("含税金额")
        private BigDecimal taxedMoney;

        @ApiModelProperty("工厂编码")
        private String factoryCode;

        @ApiModelProperty("工厂名称")
        private String factoryName;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("失效日期")
        private LocalDateTime expireDate;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

    }
}
