package com.elitesland.inv.wms;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.ido.InvIdoWmsCallBackParam;
import com.elitesland.inv.dto.odo.InvOdoWmsCallBackParam;
import com.elitesland.inv.dto.sc.InvScWmsCallBackParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvWmsCallbackProvider.PATH)
public interface InvWmsCallbackProvider {

    String PATH = "/wms/callback";

    /**
     * 入库单确认回调
     * @param idoWmsCallBackParam
     * @return
     */
    @PostMapping("/ido")
    ApiResult callbackIdoConfirm(@Valid @RequestBody InvIdoWmsCallBackParam idoWmsCallBackParam);

    /**
     * 出库单确认回调
     * @param odoWmsCallBackParam
     * @return
     */
    @PostMapping("/odo")
    ApiResult callbackOdoConfirm(@Valid @RequestBody InvOdoWmsCallBackParam odoWmsCallBackParam);

    /**
     * 入库单上传回写
     * @param wmsResult
     * @return
     */
    @PostMapping("/wms/ido")
    ApiResult idoWmsResult(@RequestBody WmsResult wmsResult);

    /**
     * 出库单上传回写
     * @param wmsResult
     * @return
     */
    @PostMapping("/wms/odo")
    ApiResult odoWmsResult(@RequestBody WmsResult wmsResult);

    @PostMapping("/wms/sc/confirm")
    ApiResult callbackScConfirm(@Valid @RequestBody InvScWmsCallBackParam invScWmsCallBackParam);

    @PostMapping("/wms/odo/odoCallBackFailResult")
    ApiResult odoCallBackFailResult(@RequestBody WmsResult wmsResult);

    @PostMapping("/wms/ido/idoCallBackFailResult")
    ApiResult idoCallBackFailResult(@RequestBody WmsResult wmsResult);


    @PostMapping("/wms/sc/result")
    ApiResult scWmsResult(@RequestBody WmsResult wmsResult);

    @PostMapping("/wms/sc/scCallBackFailResult")
    ApiResult scCallBackFailResult(@RequestBody WmsResult wmsResult);

}
