package com.elitesland.inv.wms;

import com.elitescloud.boot.mq.common.BaseMessage;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class WmsMqPushParam extends BaseMessage implements Serializable {
    public static final String DOC_IDO = "I";
    public static final String DOC_ODO = "O";

    public static final String DOC_SC = "SC";

    private static final long serialVersionUID = 8180247780167925432L;

    @ApiModelProperty("出入库id")
    private Long id;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("外部仓库类型")
    private String outWhType;

    @ApiModelProperty("外部仓库编码")
    private String outWhCode;

    @ApiModelProperty("出入库单号")
    private String docNo;

    @ApiModelProperty("I：入库单，O：出库单")
    private String docType;

    @ApiModelProperty("业务单据id，如：调拨单、发货单、调整单.....")
    private Long relateDocId;

    @ApiModelProperty("业务单据单号，如：调拨单、发货单、调整单.....")
    private String relateDocNo;

    @ApiModelProperty("业务单据类型，[UDC]yst-inv:INV_DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("开始推送时间")
    private LocalDateTime createTime = LocalDateTime.now();

    private String businessKey;

}
