package com.elitesland.inv.dto.sc;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 01月 08日 17:30
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScDRpcDTO", description = "商品变更单查询")
public class InvScDRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -8799505944990689631L;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("行号")
    private Double lineNo;

    @ApiModelProperty("行状态")
    private String lineStatus;

    @ApiModelProperty("行类型")
    private String lineType;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String spec;

    @ApiModelProperty("商品品牌")
    private String brand;

    @ApiModelProperty("商品品牌名称")
    private String brandName;

    @ApiModelProperty("商品品类")
    String itemCateCode;

    @ApiModelProperty("商品品类名")
    String itemCateCodeName;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("计划批次")
    private String lotNo;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("调整计划数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("商品原状态")
    @SysCode(sys = "yst-inv",mod = "STK_ITM_STATUS")
    private String originLimit1;
    private String originLimit1Name;

    @ApiModelProperty("商品新状态")
    @SysCode(sys = "yst-inv",mod = "STK_ITM_STATUS")
    private String newLimit1;
    private String newLimit1Name;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("入库日期")
    private LocalDateTime stkInDate;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据行号")
    private String outerLineno;

    @ApiModelProperty("WMS单据号")
    private String wmsNo;

    @ApiModelProperty("WMS单据行号")
    private String wmsLineno;

    @ApiModelProperty("限定字段2")
    private String limit2;

    @ApiModelProperty("限定字段3")
    private String limit3;

    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;

    @ApiModelProperty("关联编号 外部单据号")
    private String relateNo;

    @ApiModelProperty("关联明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDid;

    @ApiModelProperty("行号")
    private Double relateLineno;

    @ApiModelProperty("实际入库数量")
    private BigDecimal acQty;

    @ApiModelProperty("实际入库批次")
    private String acLotNo;

    @ApiModelProperty("批次Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long lotId;

    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressType;

    @ApiModelProperty("调整数量(辅助单位)")
    private BigDecimal qty2;

    @ApiModelProperty("单位2（辅助单位）")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty(name = "有效小数位")
    private Integer places;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    private String manuFactory;
    private String manuFactoryName;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;


}
