package com.elitesland.inv.dto.sc;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 11日 13:36
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScWmsCallBackParam", description = "商品库存状态wms 回调传参")
public class InvScWmsCallBackParam implements Serializable {

    private static final long serialVersionUID = -1271220193903195400L;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("出库单单号")
    @NotBlank(message = "出库单单号不能为空")
    private String docNo;

    @ApiModelProperty("wms 单号")
    private String wmsNo;

    @ApiModelProperty("明细信息")
    @NotEmpty(message = "明细信息不能为空")
    private List<WmsCallbackLine> details;

    @Data
    public static class WmsCallbackLine implements Serializable {

        private static final long serialVersionUID = -6478652009258394284L;

        @ApiModelProperty("中台行明细ID（唯一key）")
        @NotNull(message = "中台行明细ID 不为空")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long lineId;

        @ApiModelProperty("原状态")
        @NotBlank(message = "原状态不能为空")
        private String fromLimit1;

        @ApiModelProperty("目标状态")
        @NotBlank(message = "目标状态不能为空")
        private String toLimit1;

        @ApiModelProperty("商品编码")
        @NotBlank(message = "商品编码不能为空")
        private String itemCode;

        @ApiModelProperty("实际批次")
        private String lotNo;

        @ApiModelProperty("实际数量(基本单位)")
        @NotNull(message = "实际数量不能为空（基本单位）")
        private BigDecimal qty;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("失效日期")
        private LocalDateTime expireDate;

        @ApiModelProperty("入库日期")
        private LocalDateTime stkInDate;

        @ApiModelProperty("生产厂家")
        private String manuFactory;

        @ApiModelProperty("库区")
        private String deter2;

        @ApiModelProperty("单位")
        private String uom;

    }
}
