package com.elitesland.inv.dto.invIo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("库存流水查询入参")
public class InvIoParamRpcDTO implements Serializable {
    private static final long serialVersionUID = -8014753420118258628L;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("库存流水ID")
    private Long invIoId;

    @ApiModelProperty("流水日期从")
    private LocalDateTime ioDateFrom;
    @ApiModelProperty("流水日期至")
    private LocalDateTime ioDateTo;

    @ApiModelProperty("转换单位系数")
    private String toUom;

    @ApiModelProperty("来源单号")
    private List<String> srcDocNos;

    @ApiModelProperty("来源行号")
    private List<Long> srcDocDids;

    @ApiModelProperty("场景码")
    private List<String> sceneCodes;
}
