package com.elitesland.inv.dto.invwh;

import com.elitesland.inv.util.BaseModelDTO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 库区实体类
 *
 * @author jeesie.jiang
 * @since 2021-6-3 14:07:33
 */

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "库区")
public class InvWhAreaRpcDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = 127735094945711342L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("secBuId")
    private Long secBuId;

    @ApiModelProperty("地址号 仓库本身的地址号")
    private Long addrNo;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;


    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("功能区类型名")
    private String deter2TypeName;

    /**
     * 库存合作伙伴编码
     */
    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    /**
     * 库存合作伙伴名称
     */
    @ApiModelProperty("合作伙伴名称")
    private String pName;

    /**
     * 合作伙伴地址
     */
    @ApiModelProperty("合作伙伴地址")
    private String pAddr;

    /**
     * 合作伙伴类型
     */
    @ApiModelProperty("合作伙伴类型")
    private String pType;
    private String pTypeName;


    /**
     * E1BP编号
     */
    @ApiModelProperty("ERP编码")
    private String outerCode;

    /**
     * ERP编号
     */
    @ApiModelProperty("ERP名")
    private String outerCodeName;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCodeName;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("详细地址")
    private String detailaddr;






}