package com.elitesland.inv.provider;


import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invstk.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie.jiang
 * @date 2022/05/08
 * <p>
 *  库存查询接口
 * </p>
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStkProvider.PATH)
public interface InvStkProvider {

    String PATH = "/invStk";
    /**
     * 根据条件查询库存
     */
    @PostMapping("/findInvStkRpcDto")
    ApiResult<List<InvStkRpcDTO>> findInvStkRpcDtoByParam(@RequestBody InvStkAllRpcDtoParam invStkAllRpcDtoParam);

    /**
     * 根据条件查询唯一库存
     */
    @PostMapping("/getInvStk")
    ApiResult<InvStkRpcDTO> getInvStk(@RequestBody InvStkRpcDtoParam param);

    @PostMapping("/getItemInvStk")
    List<ItmInvStkItemRpcDTO> getItemInvStk(@RequestBody InvStkItemRpcDtoParam param);

    /**
     * 分页查询批次库存
     * @param param
     * @return
     */
    @PostMapping("/searchLotPaging")
    PagingVO<InvStkDRpcDTO> searchLotPaging(@RequestBody InvStkDRpcDtoParam param);

    @PostMapping("/searchPaging")
    PagingVO<InvStkGroupRpcDTO> searchPaging(@RequestBody InvStkAllRpcDtoParam param);

    /**
     * 查询逻辑性库存流水,生成对应财务单据(应收单,应付单)
     *
     * @param param
     * @return
     */
    @PostMapping("/selectLogicInvIoByParam")
    List<InvIoFinReceiptRpcDTO> selectLogicInvIoByParam(@RequestBody InvIoFinReceiptRpcDtoParam param);

    /**
     * 根据库存流水ID更新生成财务单据标识
     * @param saveRpcParam 入参
     * @return
     */
    @PostMapping("/updateFinInterFlag")
    void updateFinInterFlag(@RequestBody InvIoFinReceiptSaveRpcParam saveRpcParam);

    /**
     * 根据库存流水来源单据编号更新生成财务单据标识
     * @param saveRpcParam 入参
     * @return
     */
    @PostMapping("/updateFinInterFlagBySrcDocNo")
    void updateFinInterFlagBySrcDocNo(@RequestBody InvIoFinReceiptSaveRpcParam saveRpcParam);

    @PostMapping("/queryInvStk")
    List<InvStkQueryRpcResult> queryInvStk(@RequestBody InvStkQueryRpcParam param);

    /**
     * 门店小程序商品库存查询
     * @param param
     * @return
     */
    @PostMapping("/queryStoreMpInvStk")
    PagingVO<InvStkStoreMpRpcDTO> queryStoreMpInvStk(@RequestBody InvStkMpQueryRpcParam param);

    @PostMapping("/queryStoreItemStk")
    List<InvStoreItemStkRpcResult> queryStoreItemStk(@RequestBody InvStoreItemStkQueryRpcParam storeItemStkQueryRpcParam);

    @PostMapping("/queryWhItemTotalStk")
    List<InvWhItemTotalStkRpcDTO> queryInvWhItemTotalStk(@RequestBody InvWhItemTotalStkRpcParam param);

    @PostMapping("/queryInvWmsWhStkItemPage")
    PagingVO<InvWmsWhStkItemPageVO> queryInvWmsWhStkItemPage(@RequestBody InvWmsWhStkItemPageParam param);

    @PostMapping("/queryInvStkByBusinessKeys")
    List<InvStkQueryRpcResult> queryInvStkForWms(@RequestBody List<String> businessKeys);



}
