package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class InvStkQueryRpcResult implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    private Long lotId;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;


    @ApiModelProperty("品项名")
    private String itemName;


    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名")
    private String whName;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;

    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 可用量
     */
    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("库存总量")
    private BigDecimal ohQty;


    @ApiModelProperty("公司编号")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("limit1")
    private String limit1;


    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("仓库优先即")
    private Integer priority;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("商品批次汇总库存量")
    private BigDecimal itmQty;

    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;

    private String businessKey;
}
