package com.elitesland.inv.dto.invwh;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
//import java.util.Map;

/**
 入参：公司编码、仓库创建时间、最近更新时间、仓库编码（选填）
 全量返回档案，爷爷茶最多10个仓
 */
@Data
public class InvWhDtoParam implements Serializable {
    private static final long serialVersionUID = 3344534498352255891L;


    @ApiModelProperty("公司编码，批量查询")
    private List<String> ouCodeList;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTimeStart;
    private LocalDateTime createTimeEnd;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTimeStart;
    private LocalDateTime modifyTimeEnd;

    @ApiModelProperty("仓库编码，批量查询")
    private List<String> whCodeList;

    @ApiModelProperty("仓库类型")
    private List<String> whTypeList;


}
