package com.elitesland.inv.dto.invwh;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 仓库(OrgWh)实体类
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:00:48
 */

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:00:48
 */
@Data
@ApiModel(value = "inv_wh", description = "仓库保存rpc接口")
public class InvWhRecvAddrSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -51945385646801579L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("仓库编码")
   private String whCode;

    //页面
    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("详细地址")
    private String detailaddr;

    /**
     * 联系人邮箱
     */
    @ApiModelProperty("仓库联系人邮箱")
    private String email;

    @ApiModelProperty("仓库联系人")
    private String contPerson;

    @ApiModelProperty("仓库联系人电话")
    private String tel;


}
