package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.out.InvOutSysDTO;
import com.elitesland.inv.dto.out.InvOutSysQueryDTO;
import com.elitesland.inv.dto.out.InvOutSysQueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvWmsProvider.PATH)
public interface InvWmsProvider {
    String PATH = "/InvWmsProvider";

    /**
     * 根据前端查询条件查询符合的业务单据id集合 入库单
     *
     * @param queryParam
     * @return 返回业务单据id，返回null表示，传入条件无效或者为空忽略查询，返回空集合表示未查到符合条件的单据
     */
    @PostMapping("/findRelateDocFromIdo")
    ApiResult<List<Long>> findRelateDocFromIdo(@RequestBody InvOutSysQueryDTO queryParam);

    /**
     * 根据前端查询条件查询符合的业务单据id集合 出库单
     *
     * @param queryParam
     * @return 返回业务单据id，返回null表示，传入条件无效或者为空忽略查询，返回空集合表示未查到符合条件的单据
     */
    @PostMapping("/findRelateDocFromOdo")
    ApiResult<List<Long>> findRelateDocFromOdo(@RequestBody InvOutSysQueryDTO queryParam);

    /**
     * 查询入库单wms系统对接相关信息
     * @param ids 业务单据id集合
     * @return
     */
    @PostMapping("/findOutSysDTOFromIdo")
    ApiResult<List<InvOutSysDTO>> findOutSysDTOFromIdo(@RequestBody List<Long> ids);

    /**
     * 查询出库单wms系统对接相关信息
     * @param ids 业务单据id集合
     * @return
     */
    @PostMapping("/findOutSysDTOFromOdo")
    ApiResult<List<InvOutSysDTO>> findOutSysDTOFromOdo(@RequestBody List<Long> ids);
}
