package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.expesne.ExpenseReCalParamRpcDTO;
import com.elitesland.inv.dto.invTrn.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author jeesie
 * @date 2022-05-18
 * <p>
 *     库存转移
 * </>
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvTrnProvider.PATH)
public interface InvTrnProvider {
    String PATH = "/invTrn";
    /**
     * 保存提交库存转移单
     * @param invTrnSaveRpcDTO
     * @return
     */
    @PostMapping("/submitInvTrn")
    ApiResult<InvTrnResultRpcDTO> submitInvTrn(@RequestBody InvTrnSaveRpcDTO invTrnSaveRpcDTO);

    /**
     * 审核库存转移单
     * @param masId
     * @return
     */
    @PostMapping("/checkInvTrn")
    Long checkInvTrn(@RequestParam("masId") Long masId);

    @PostMapping("/updateExpFlag")
    void updateExpFlag(@RequestBody ExpenseReCalParamRpcDTO expenseReCalParamRpcDTO);

    /**
     * 库存转移移库确认
     */
    @PostMapping("/confirmInvTrn")
    Long confirmInvTrn(@RequestParam("masId") Long masId);

    /**
     * 收货确认
     */
    @PostMapping("/recvConfirmInvTrn")
    Long recvConfirmInvTrn(@RequestParam("masId") Long masId);

    @GetMapping("/findById")
    ApiResult<InvTrnRpcDTO> findById(@RequestParam("id") Long id);

    /**
     * 根据明细ID查询行号等信息
     * 财务 逻辑性销售出库/逻辑性销售退货入库流水生成应收单时使用
     *
     * @param invTrnDRpcDtoParam 查询参数
     * @return
     */
    @PostMapping("/queryDodByParam")
    List<InvTrnDRpcDTO> queryDodByParam(@RequestBody InvTrnDRpcDtoParam invTrnDRpcDtoParam);

    /**
     * 撤销库存转移单
     * @param docNo
     * @return
     */
    @PostMapping("/withdrawInvTrn")
    ApiResult<Long> withdrawInvTrn(String docNo);


}
