package com.elitesland.inv.dto.invAj;

import com.elitesland.inv.util.AjDocTypeEnum;
import com.elitesland.inv.util.SourceTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 31日 17:43
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvAjSaveRpcDTO", description = "库存调整保存")
public class InvAjSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = 5036228893591875953L;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("来源系统类型")
    @NotNull(message = "来源系统类型不能为空")
    private SourceTypeEnum sourceType;

    @ApiModelProperty("唯一请求ID（每次请求生成唯一ID）")
    @NotBlank(message = "请求ID不能为空")
    private String requestId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("来源单号")
    private String sourceDocNo;

    @ApiModelProperty("来源单据ID")
    private Long sourceDocId;

    @ApiModelProperty("来源单号类别")
    private String sourceDocCls;

    @ApiModelProperty("ERP或WMS外部仓库编码")
    private String otherWhCode;

    @ApiModelProperty("外部系统仓库类型")
    private String otherWhType;

    @ApiModelProperty("中台功能区编码（无则默认指定）")
    private String deter2;

    @ApiModelProperty("调整类型")
    @NotNull(message = "调整类型不能为空")
    private AjDocTypeEnum docType;

    @ApiModelProperty("中台仓库编码")
    private String whCode;

    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    private String docStatus;


    @ApiModelProperty("调整单审核状态")
    private String procInstStatus;

    @ApiModelProperty("调整原因")
    private String reasonCode;

    @ApiModelProperty("库存调整明细")
    @NotEmpty(message = "调整明细不能为空")
    private List<InvAjdSaveRpcDTO> invAjSaveRpcDtoList;
}
