/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.inv.provider;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.inv.dto.out.InvOutSysDTO;
import com.elitesland.inv.dto.out.InvOutSysQueryDTO;
import com.elitesland.inv.dto.out.InvOutSysQueryParam;
import com.elitesland.inv.dto.out.InvOutSysVO;
import com.elitesland.inv.dto.out.InvOutSysVO2;
import com.elitesland.inv.provider.InvWmsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class InvWmsInfoClient {
    private static InvWmsProvider invWmsProvider;
    private static UdcProvider udcProvider;

    private static void init() {
        invWmsProvider = (InvWmsProvider)SpringUtil.getBean(InvWmsProvider.class);
        udcProvider = (UdcProvider)SpringUtil.getBean(UdcProvider.class);
    }

    public static List<Long> findRelateDocFromIdo(InvOutSysQueryParam queryParam) {
        InvWmsInfoClient.init();
        InvOutSysQueryDTO queryDTO = InvOutSysQueryDTO.build(queryParam);
        if (!queryDTO.hasParam()) {
            return null;
        }
        List result = (List)invWmsProvider.findRelateDocFromIdo(queryDTO).computeData();
        return result == null ? new ArrayList() : result;
    }

    public static List<Long> findRelateDocFromOdo(InvOutSysQueryParam queryParam) {
        InvWmsInfoClient.init();
        InvOutSysQueryDTO queryDTO = InvOutSysQueryDTO.build(queryParam);
        if (!queryDTO.hasParam()) {
            return null;
        }
        List result = (List)invWmsProvider.findRelateDocFromOdo(queryDTO).computeData();
        return result == null ? new ArrayList() : result;
    }

    public static void refreshWmsInfoFromIdo(List<? extends InvOutSysVO> sysVOS) {
        if (CollectionUtil.isEmpty(sysVOS)) {
            return;
        }
        InvWmsInfoClient.init();
        List<Long> ids = sysVOS.stream().filter(i -> i != null).map(i -> i.getInvDocId()).collect(Collectors.toList());
        List outSysDTOFromIdo = (List)invWmsProvider.findOutSysDTOFromIdo(ids).computeData();
        InvWmsInfoClient.refreshWmsInfo(sysVOS, outSysDTOFromIdo);
    }

    public static void refreshWmsInfoFromOdo(List<? extends InvOutSysVO> sysVOS) {
        if (CollectionUtil.isEmpty(sysVOS)) {
            return;
        }
        InvWmsInfoClient.init();
        List<Long> ids = sysVOS.stream().filter(i -> i != null).map(i -> i.getInvDocId()).collect(Collectors.toList());
        List outSysDTOFromOdo = (List)invWmsProvider.findOutSysDTOFromOdo(ids).computeData();
        InvWmsInfoClient.refreshWmsInfo(sysVOS, outSysDTOFromOdo);
    }

    public static void refreshWmsInfo(List<? extends InvOutSysVO> sysVOS, List<InvOutSysDTO> sysDTOS) {
        if (CollectionUtil.isEmpty(sysDTOS)) {
            return;
        }
        InvWmsInfoClient.init();
        Map<Long, InvOutSysDTO> sysInfoMap = sysDTOS.stream().collect(Collectors.toMap(i -> i.getInvDocId(), i -> i, (o, n) -> n));
        Map uomMap = udcProvider.getValueMapByUdcCode("yst-supp", Set.of("EXTERNAL_SYNC_STATUS", "EXTERNAL_FEEDBACK_STATUS"));
        for (InvOutSysVO invOutSysVO : sysVOS) {
            InvOutSysDTO invOutSysDTO = sysInfoMap.get(invOutSysVO.getInvDocId());
            if (invOutSysDTO == null) continue;
            invOutSysVO.setWmsCancelLog(invOutSysDTO.getWmsCancelLog());
            invOutSysVO.setWmsFeedbackStatus(invOutSysDTO.getWmsFeedbackStatus());
            invOutSysVO.setWmsStatus(invOutSysDTO.getWmsStatus());
            invOutSysVO.setWmsTime(invOutSysDTO.getWmsTime());
            invOutSysVO.setWmsLog(invOutSysDTO.getWmsLog());
            invOutSysVO.setWmsCancelTime(invOutSysDTO.getWmsCancelTime());
            invOutSysVO.setWmsStatusName((String)((Map)uomMap.getOrDefault("EXTERNAL_SYNC_STATUS", new HashMap())).get(invOutSysDTO.getWmsStatus()));
            invOutSysVO.setWmsFeedbackStatusName((String)((Map)uomMap.getOrDefault("EXTERNAL_FEEDBACK_STATUS", new HashMap())).get(invOutSysDTO.getWmsFeedbackStatus()));
        }
    }

    public static void refreshWms2Info(List<? extends InvOutSysVO2> sysVOS, List<InvOutSysDTO> sysDTOS) {
        if (CollectionUtil.isEmpty(sysDTOS)) {
            return;
        }
        InvWmsInfoClient.init();
        Map<Long, InvOutSysDTO> sysInfoMap = sysDTOS.stream().collect(Collectors.toMap(i -> i.getInvDocId(), i -> i, (o, n) -> n));
        Map uomMap = udcProvider.getValueMapByUdcCode("yst-supp", Set.of("EXTERNAL_SYNC_STATUS", "EXTERNAL_FEEDBACK_STATUS"));
        for (InvOutSysVO2 invOutSysVO2 : sysVOS) {
            InvOutSysDTO invOutSysDTO = sysInfoMap.get(invOutSysVO2.getInvDocId());
            if (invOutSysDTO == null) continue;
            invOutSysVO2.setWmsCancelLog2(invOutSysDTO.getWmsCancelLog());
            invOutSysVO2.setWmsFeedbackStatus2(invOutSysDTO.getWmsFeedbackStatus());
            invOutSysVO2.setWmsStatus2(invOutSysDTO.getWmsStatus());
            invOutSysVO2.setWmsTime2(invOutSysDTO.getWmsTime());
            invOutSysVO2.setWmsLog2(invOutSysDTO.getWmsLog());
            invOutSysVO2.setWmsCancelTime2(invOutSysDTO.getWmsCancelTime());
            invOutSysVO2.setWmsStatus2Name((String)((Map)uomMap.getOrDefault("EXTERNAL_SYNC_STATUS", new HashMap())).get(invOutSysDTO.getWmsStatus()));
            invOutSysVO2.setWmsFeedbackStatus2Name((String)((Map)uomMap.getOrDefault("EXTERNAL_FEEDBACK_STATUS", new HashMap())).get(invOutSysDTO.getWmsFeedbackStatus()));
        }
    }
}

