package com.elitesland.inv.dto.sc;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 01月 08日 17:01
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScRpcDTO", description = "商品变更单")
public class InvScRpcDTO extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = -8737952251442034091L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("原因码")
    private String reasonCode;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审批人名")
    private String apprUserName;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人员工编码")
    private String applyEmpCode;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    private String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("记帐日期")
    private LocalDateTime finDate;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("总数量")
    private BigDecimal qty;

    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("推送WMS状态")
    private String wmsStatus;

    @ApiModelProperty("接收WMS回传状态")
    private String wmsFeedbackStatus;

    @ApiModelProperty("推送WMS异常日志")
    private String wmsLog;

    @ApiModelProperty("推送WMS时间")
    private LocalDateTime wmsTime;

    @ApiModelProperty("推送ERP状态")
    private String erpStatus;

    @ApiModelProperty("接收ERP回传状态")
    private String erpFeedbackStatus;

    @ApiModelProperty("推送ERP异常日志")
    private String erpLog;

    @ApiModelProperty("推送ERP时间")
    private LocalDateTime erpTime;

    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;

    @ApiModelProperty("关联编号 外部单据号")
    private String relateNo;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    @ApiModelProperty("wms 系统类型")
    private String outWhSysType;

    @ApiModelProperty("外部仓库货主(wms)")
    private String outWhOwer;

    @ApiModelProperty("外部WMS仓库类型编码")
    private String otherWhCode;

    @ApiModelProperty("单据明细信息")
    private List<InvScDRpcDTO> invScDRespVOList;
}
