package com.elitesland.inv.dto.sc;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 01月 08日 17:21
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvScConfirmParamRpcDTO", description = "商品变更单确认")
public class InvScConfirmParamRpcDTO  implements Serializable {

    private static final long serialVersionUID = 8606355653885757359L;

    @ApiModelProperty("单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "单据ID 不为空")
    private Long id;

    @ApiModelProperty("是否WSM 接口")
    @NotNull(message = "是否WSM 接口")
    private Boolean intFlag;

    @ApiModelProperty("调整入参详情")
    private List<InvScDetail> details;

    public Boolean getIntFlag(){
        if(this.intFlag == null){
            return Boolean.FALSE;
        }else{
            return this.intFlag;
        }
    }

    @Data
    public static class InvScDetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("明细ID")
        @NotNull(message = "明细ID 不为空")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long id;

        @ApiModelProperty("品项ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("实际出入数量")
        @NotNull(message = "实际出入数量 不为空")
        private BigDecimal acQty;

        @ApiModelProperty("实际出入库批次")
        private String acLotNo;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("失效日期")
        private LocalDateTime expireDate;

        @ApiModelProperty("入库日期")
        private LocalDateTime stkInDate;

    }
}
